VERSION 5.00
Begin VB.Form frmMain 
   BackColor       =   &H8000000C&
   Caption         =   "VB Vidcap"
   ClientHeight    =   3645
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4725
   Icon            =   "VB Vidcap.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   243
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   315
   StartUpPosition =   3  'Windows Default
   Begin VB.Label StatusBar 
      BackColor       =   &H00C0C0C0&
      Caption         =   "StatusBar"
      Height          =   255
      Left            =   1320
      TabIndex        =   0
      Top             =   3000
      Width           =   2175
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&Fila"
      Begin VB.Menu mnuAllocate 
         Caption         =   "&Espacio"
      End
      Begin VB.Menu nada 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "S&alir"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edicin"
      Begin VB.Menu mnuCopy 
         Caption         =   "&Copiar"
         Shortcut        =   ^C
      End
   End
   Begin VB.Menu mnuControl 
      Caption         =   "&Control"
      Begin VB.Menu mnuStart 
         Caption         =   "&Iniciar"
      End
      Begin VB.Menu mnuDisplay 
         Caption         =   "&Mostrar"
      End
      Begin VB.Menu mnuFormat 
         Caption         =   "&Formato"
         Shortcut        =   ^F
      End
      Begin VB.Menu mnuSource 
         Caption         =   "R&ecurso"
      End
      Begin VB.Menu mnuCompression 
         Caption         =   "Co&mpresin"
      End
      Begin VB.Menu mnuLine1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSelect 
         Caption         =   "&Seleccionar"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuScale 
         Caption         =   "Es&cala"
         Checked         =   -1  'True
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuPreview 
         Caption         =   "&Vista previa"
         Checked         =   -1  'True
         Shortcut        =   ^P
      End
      Begin VB.Menu mnuLine2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAlwaysVisible 
         Caption         =   "S&iempre visible"
         Shortcut        =   ^W
      End
   End
   Begin VB.Menu MnuAyuda 
      Caption         =   "&Ayuda"
      Begin VB.Menu MnuAcercade 
         Caption         =   "&Acerca de..."
         Shortcut        =   {F1}
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function ShellAbout Lib "shell32.dll" Alias "ShellAboutA" (ByVal hWnd As Long, ByVal szApp As String, ByVal szOtherStuff As String, ByVal hIcon As Long) As Long

Option Explicit

Private Sub Form_Load()
    
    Dim lpszName As String * 100
    Dim lpszVer As String * 100
    Dim Caps As CAPDRIVERCAPS
        
    '//Crear Ventana de Captura
    capGetDriverDescriptionA 0, lpszName, 100, lpszVer, 100  '// Info Dispositivo
    lwndC = capCreateCaptureWindowA(lpszName, WS_CAPTION Or WS_THICKFRAME Or WS_VISIBLE Or WS_CHILD, 0, 0, 160, 120, Me.hWnd, 0)

    '// Poner nombre del dispositivo de captura
    SetWindowText lwndC, lpszName
    
    '//Fijar la funcin video
    capSetCallbackOnStatus lwndC, AddressOf MyStatusCallback
    capSetCallbackOnError lwndC, AddressOf MyErrorCallback
    
    '// Conectar ventana de captura al dispositivo
    If capDriverConnect(lwndC, 0) Then
            
        capDriverGetCaps lwndC, VarPtr(Caps), Len(Caps)
        
        
        If Caps.fHasDlgVideoSource = 0 Then mnuSource.Enabled = False
        If Caps.fHasDlgVideoFormat = 0 Then mnuFormat.Enabled = False
        If Caps.fHasDlgVideoDisplay = 0 Then mnuDisplay.Enabled = False
        
        '// Encender escala
        capPreviewScale lwndC, True
            
        '// Poner vista previa en milisegundos
        capPreviewRate lwndC, 66
        
        '// Iniciar vista previa de imagenes de la Web Cam
        capPreview lwndC, True
            
        '// Resizar imagen con el del dispositivo
        ResizeCaptureWindow lwndC

    End If


End Sub

Private Sub Form_Resize()
On Error Resume Next
Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2 'Centra el formulario completamente
' clasifique la etiqueta al rea de la barra de estado (para los usuarios que no tienen favorable edicin de VB)
    StatusBar.Move 0, ScaleHeight - StatusBar.Height, ScaleWidth

End Sub

Private Sub Form_Unload(Cancel As Integer)

    '// Cerrar todas las llamadas
    capSetCallbackOnError lwndC, vbNull
    capSetCallbackOnStatus lwndC, vbNull
    capSetCallbackOnYield lwndC, vbNull
    capSetCallbackOnFrame lwndC, vbNull
    capSetCallbackOnVideoStream lwndC, vbNull
    capSetCallbackOnWaveStream lwndC, vbNull
    capSetCallbackOnCapControl lwndC, vbNull
    

End Sub

Private Sub MnuAcercade_Click()
Call ShellAbout(Me.hWnd, "Vb Vidcap32", "Copyright 2006, Dj_Dexter", Me.Icon)
End Sub

Private Sub mnuAllocate_Click()

 Dim sFile As String * 250
 Dim lSize As Long
 
 '// Saber espacio disponible para la captura
 lSize = 1000000
 sFile = "C:\TEMP.AVI"
 capFileSetCaptureFile lwndC, sFile
 capFileAlloc lwndC, lSize
 
End Sub

Private Sub mnuAlwaysVisible_Click()
    
    mnuAlwaysVisible.Checked = Not (mnuAlwaysVisible.Checked)
    
    If mnuAlwaysVisible.Checked Then
        SetWindowPos Me.hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE
    Else
        SetWindowPos Me.hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE
    End If


End Sub

Private Sub mnuCompression_Click()
'Mostrar dialogo de Compresin
    
    capDlgVideoCompression lwndC

End Sub

Private Sub mnuCopy_Click()

    capEditCopy lwndC
        
End Sub

Private Sub mnuDisplay_Click()
'Mostrar dialogo de mostrar (si el dispositivo lo permite)

    capDlgVideoDisplay lwndC
    
End Sub

Private Sub mnuExit_Click()

    Unload Me
    
End Sub

Private Sub mnuFormat_Click()
'Mostrar dialogo de Formato de Imagen


    capDlgVideoFormat lwndC
    ResizeCaptureWindow lwndC

End Sub

Private Sub mnuPreview_Click()

    frmMain.StatusBar.Caption = vbNullString
    mnuPreview.Checked = Not (mnuPreview.Checked)
    capPreview lwndC, mnuPreview.Checked
    
End Sub

Private Sub mnuScale_Click()
    
    mnuScale.Checked = Not (mnuScale.Checked)
    capPreviewScale lwndC, mnuScale.Checked
    
    If mnuScale.Checked Then
       SetWindowLong lwndC, GWL_STYLE, WS_THICKFRAME Or WS_CAPTION Or WS_VISIBLE Or WS_CHILD
    Else
       SetWindowLong lwndC, GWL_STYLE, WS_BORDER Or WS_CAPTION Or WS_VISIBLE Or WS_CHILD
    End If

    ResizeCaptureWindow lwndC
    
End Sub

Private Sub mnuSelect_Click()
    
    frmSelect.Show vbModal, Me

End Sub

Private Sub mnuSource_Click()
'Mostrar dialogo de recurso, o configurar
    
    capDlgVideoSource lwndC

End Sub

Private Sub mnuStart_Click()
'Se empieza a capturar, se termina la captura apretando escape (esc)
    
    Dim sFileName As String
    Dim CAP_PARAMS As CAPTUREPARMS
    
    capCaptureGetSetup lwndC, VarPtr(CAP_PARAMS), Len(CAP_PARAMS)
    
    CAP_PARAMS.dwRequestMicroSecPerFrame = (1 * (10 ^ 6)) / 30  ' 30 Cuadros por segundo
    CAP_PARAMS.fMakeUserHitOKToCapture = True
    CAP_PARAMS.fCaptureAudio = False
    
    capCaptureSetSetup lwndC, VarPtr(CAP_PARAMS), Len(CAP_PARAMS)
    
    sFileName = "C:\mivideo.avi"
    
    capCaptureSequence lwndC  ' Iniciar Captura!
    capFileSaveAs lwndC, sFileName  ' Copiar el video dentro de la fila.

End Sub
